/* ------------------------------------------------------------------------------
  File: CHR_i2c.h
  Author: CH Robotics
  Version: 1.0
  
  Description: Code for working with i2c bus
------------------------------------------------------------------------------ */ 

#ifndef __CHR_I2C_H
#define __CHR_I2C_H

#include "stm32f10x.h"

#define	I2C_TX_BUFSIZE			16
#define	I2C_RX_BUFSIZE			16

#define	I2C_ACK_ATTEMPTS		5000
#define	MAX_RETRIES				10000

#define	I2C_TRANSMITTER 		I2C_Direction_Transmitter
#define	I2C_RECEIVER			I2C_Direction_Receiver


/* 400kHz bus speed */
#define	I2C_CLOCK_PERIOD			(2.5)		// Clock period in microseconds
#define	I2C_CLOCK_PERIOD_DIV2	(0)	// Half the clock period in microseconds

/* 200kHz bus speed 
#define	I2C_CLOCK_PERIOD			(5)		// Clock period in microseconds
#define	I2C_CLOCK_PERIOD_DIV2	(2.5)	// Half the clock period in microseconds
*/

#define	I2C_BIT_SET					1
#define	I2C_BIT_CLEAR				0

#define	I2C_ACK_DISABLE			1
#define	I2C_ACK_ENABLE				0

#define	I2C_SEND_START				1
#define	I2C_NO_START				0
#define	I2C_SEND_STOP				1
#define	I2C_NO_STOP					0

#define	I2C_SCL_PIN					GPIO_Pin_6
#define	I2C_SDA_PIN					GPIO_Pin_7
#define	I2C_PORT						GPIOB

#define	I2C_SUCCESS					0
#define	I2C_ARBITRATION_LOST		10
#define	I2C_NACK						1
#define	I2C_TIMEOUT					11

// Defines the length of time the i2c software will wait for clock stretching
// The number of attempts simply corresponds with the number of iterations
// through a for loop.
#define	I2C_MAX_ATTEMPTS			1000

#define	I2C_DELAY_INIT()			int _counter;
#define	I2C_DELAY()					for( _counter = 0; _counter < 5; _counter++ ) { asm volatile("mov r0, r0"); }
#define	I2C_DELAY_SHORT()			asm volatile("mov r0, r0")

// i2c function calls
int32_t i2cBufWrite( uint8_t addr, uint8_t* i2cData, uint8_t length );
int32_t i2cRead( uint8_t addr, uint8_t* i2cData, uint8_t length );
int32_t i2cStart();
void i2cStop();
int32_t i2cWait();

void i2cReset();

// Software-emulated i2c function calls (these are internal and needn't be called by the user)
uint8_t i2cReadSDA( void );
void i2cClearSDA( void );
void i2cClearSCL( void );
uint8_t i2cReadSCL( void );
uint8_t i2cGenerateStart( void );
uint8_t i2cWriteBit( uint8_t value );
uint8_t i2cReadBit( void );
uint8_t i2cGenerateStop( void );

// Software-emulated i2c function calls.  Use these ones.
uint8_t i2cBatchWrite( uint8_t address7, uint8_t* txBuffer, uint8_t bytesToWrite );
uint8_t i2cBatchRead( uint8_t address7, uint8_t device_start_address, uint8_t* rxBuffer, uint8_t bytesToRead );
uint8_t i2cTransmitByte( uint8_t byte, uint8_t send_start, uint8_t send_stop );
uint8_t i2cReadByte( uint8_t nack, uint8_t send_stop, uint8_t* status );

// Buffers for storing i2c data
extern uint8_t g_i2cTxBuf[I2C_TX_BUFSIZE];
extern uint8_t g_i2cRxBuf[I2C_RX_BUFSIZE];
extern uint8_t g_i2cBytesToTransmit;
extern uint8_t g_i2cBytesToReceive;
extern uint8_t g_i2cReadPrelude;
extern __IO uint8_t g_i2cTxPtr;
extern __IO uint8_t g_i2cRxPtr;
extern __IO uint8_t g_i2cBusy;
extern __IO uint8_t g_i2cBusError;
extern __IO uint8_t g_i2cDirection;
extern __IO uint8_t g_i2cCurrentSlaveAddress;

#endif
